varying vec2 		texcoord;
uniform sampler2D 	HDRTex;
uniform sampler2D 	lumTex;

uniform float 		lumAvg;
float				lum;

uniform float		GAMMA;


uniform float A;// = 0.15; // shoulder strength
uniform float B;// = 0.50; // linear strength
uniform float C;// = 0.10;	// linear angle
uniform float D;// = 0.20; // toe strength
uniform float E;// = 0.02; // toe numerator
uniform float F;// = 0.30; // toe denomimnator
uniform float W;// = 20.0;//11.2; // linear white

vec3 Uncharted2Tonemap(vec3 x)
{
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
	
void main()
{
	vec3 texColor = texture2D(HDRTex, texcoord).rgb;
	float 	AVG=texture2D(lumTex,texcoord).r;
	lum=dot(vec3(0.27, 0.67, 0.06),texColor.xyz);
	texColor *= /*lum*/0.5/AVG; 		 // Hardcoded Exposure Adjustment
	float ExposureBias = lumAvg;	//2.0f;
	vec3 curr = Uncharted2Tonemap(ExposureBias*texColor);
	vec3 whiteScale = 1.0/Uncharted2Tonemap(vec3(W));
	vec3 color = curr*whiteScale;
	color = pow(color,vec3(1.0/(2.2*GAMMA)));
	
	//color = pow(clamp(color,vec3(0.0),vec3(1.0)),vec3(1.0/GAMMA));
	
	// aply gamma
	gl_FragColor=vec4(color,1.0);
}
